<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FreelanceUsers extends Model 
{

    protected $table = 'fl_users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('mobile', 'email', 'otp', 'status');
    protected $hidden = array('password');

    public function previousExperience()
    {
        return $this->hasMany('App\Models\FreelancePreviousExperience');
    }

}